from django import forms
from django.utils.translation import gettext_lazy as _


class ContactForm(forms.Form):
    email = forms.EmailField(label=_('Email'))
    subject = forms.CharField(label=_('Subject'))
    message = forms.CharField(
        label=_('Message'), widget=forms.Textarea(attrs={'rows': 5}))
